/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.Color;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.controls.TextField;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.blockout.views.Window;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.client.gui.WindowScan;
import com.ldtteam.structurize.client.gui.WindowShapeTool;
import com.ldtteam.structurize.network.messages.ReplaceBlockMessage;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.LanguageHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.AirItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class WindowReplaceBlock
extends AbstractWindowSkeleton {
    private static final String BUTTON_DONE = "done";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String INPUT_NAME = "name";
    private static final String WINDOW_REPLACE_BLOCK = ":gui/windowreplaceblock.xml";
    private final ItemStack from;
    private final BlockPos pos1;
    private static final int WHITE = Color.getByName("white", 0);
    private final BlockPos pos2;
    private final List<ItemStack> allItems = new ArrayList<ItemStack>();
    private List<ItemStack> filteredItems = new ArrayList<ItemStack>();
    private final ScrollingList resourceList;
    private String filter = "";
    private final boolean mainBlock;
    private final Window origin;
    private int tick;

    public WindowReplaceBlock(@NotNull ItemStack initialStack, BlockPos pos1, BlockPos pos2, Window origin) {
        super("structurize:gui/windowreplaceblock.xml");
        this.from = initialStack;
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.mainBlock = false;
        this.resourceList = this.findPaneOfTypeByID("resources", ScrollingList.class);
        this.origin = origin;
    }

    public WindowReplaceBlock(@NotNull ItemStack initialStack, BlockPos pos, boolean main, Window origin) {
        super("structurize:gui/windowreplaceblock.xml");
        this.from = initialStack;
        this.pos1 = pos;
        this.pos2 = BlockPos.field_177992_a;
        this.mainBlock = main;
        this.resourceList = this.findPaneOfTypeByID("resources", ScrollingList.class);
        this.origin = origin;
    }

    @Override
    public void onOpened() {
        this.findPaneOfTypeByID("resourceIconFrom", ItemIcon.class).setItem(this.from);
        this.findPaneOfTypeByID("resourceNameFrom", Text.class).setText((IFormattableTextComponent)this.from.func_200301_q());
        this.findPaneOfTypeByID("resourceIconTo", ItemIcon.class).setItem(new ItemStack((IItemProvider)Blocks.field_150350_a));
        this.findPaneOfTypeByID("resourceNameTo", Text.class).setText((IFormattableTextComponent)new ItemStack((IItemProvider)Blocks.field_150350_a).func_200301_q());
        this.updateResources();
        this.updateResourceList();
        this.findPaneOfTypeByID(INPUT_NAME, TextField.class).setHandler(input -> {
            String filterNew = this.findPaneOfTypeByID(INPUT_NAME, TextField.class).getText().toLowerCase(Locale.US);
            if (!filterNew.trim().equals(this.filter)) {
                this.filter = filterNew;
                this.tick = 10;
            }
        });
        this.registerButton(BUTTON_DONE, this::doneClicked);
        this.registerButton(BUTTON_CANCEL, (Button button) -> this.origin.open());
        this.registerButton("select", (Button button) -> {
            int row = this.resourceList.getListElementIndexByPane((Pane)((Object)button));
            ItemStack to = this.filteredItems.get(row);
            this.findPaneOfTypeByID("resourceIconTo", ItemIcon.class).setItem(to);
            this.findPaneOfTypeByID("resourceNameTo", Text.class).setText((IFormattableTextComponent)to.func_200301_q());
        });
    }

    private void updateResources() {
        this.allItems.clear();
        this.allItems.addAll((Collection<ItemStack>)ImmutableList.copyOf((Collection)StreamSupport.stream(Spliterators.spliteratorUnknownSize(ForgeRegistries.ITEMS.iterator(), 16), false).filter(item -> item instanceof AirItem || item instanceof BlockItem || item instanceof BucketItem && ((BucketItem)item).getFluid() != Fluids.field_204541_a).map(ItemStack::new).collect(Collectors.toList())));
        this.filteredItems = this.allItems;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.tick > 0 && --this.tick == 0) {
            this.filteredItems = this.filter.isEmpty() ? this.allItems : this.allItems.stream().filter(stack -> stack.func_77977_a().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || stack.func_200301_q().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US))).collect(Collectors.toList());
            this.filteredItems.sort(Comparator.comparingInt(s1 -> StringUtils.getLevenshteinDistance((CharSequence)s1.func_200301_q().getString(), (CharSequence)this.filter)));
        }
    }

    public void doneClicked(Button button) {
        ItemStack to = this.findPaneOfTypeByID("resourceIconTo", ItemIcon.class).getItem();
        if (!ItemStackUtils.isEmpty(to).booleanValue() || to.func_77973_b() instanceof AirItem) {
            if (this.origin instanceof WindowScan) {
                BlockState fromBS = BlockUtils.getBlockStateFromStack(this.from);
                BlockState toBS = BlockUtils.getBlockStateFromStack(to);
                ArrayList missingProperties = new ArrayList(toBS.func_235904_r_());
                missingProperties.removeAll(fromBS.func_235904_r_());
                if (!missingProperties.isEmpty()) {
                    LanguageHandler.sendMessageToPlayer((PlayerEntity)Minecraft.func_71410_x().field_71439_g, "structurize.gui.replaceblock.ambiguous_properties", LanguageHandler.translateKey(fromBS.func_177230_c().func_149739_a()), LanguageHandler.translateKey(toBS.func_177230_c().func_149739_a()), missingProperties.stream().map(prop -> this.getPropertyName((Property<?>)prop) + " - " + prop.func_177701_a()).collect(Collectors.joining(", ", "[", "]")));
                }
                if (toBS.func_177230_c().func_203417_a(ModBlocks.NULL_PLACEMENT)) {
                    LanguageHandler.sendMessageToPlayer((PlayerEntity)Minecraft.func_71410_x().field_71439_g, "structurize.gui.replaceblock.null_placement", LanguageHandler.translateKey(toBS.func_177230_c().func_149739_a()));
                }
                Network.getNetwork().sendToServer(new ReplaceBlockMessage(this.pos1, this.pos2, this.from, to));
            } else if (this.origin instanceof WindowShapeTool) {
                ((WindowShapeTool)this.origin).updateBlock(to, this.mainBlock);
            }
            this.origin.open();
        }
    }

    public void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowReplaceBlock.this.filteredItems.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = (ItemStack)WindowReplaceBlock.this.filteredItems.get(index);
                Text resourceLabel = rowPane.findPaneOfTypeByID("resourceName", Text.class);
                resourceLabel.setText((IFormattableTextComponent)resource.func_200301_q());
                resourceLabel.setColors(WHITE);
                rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class).setItem(resource);
            }
        });
    }

    private String getPropertyName(Property<?> clazz) {
        return clazz instanceof BooleanProperty ? "Boolean" : (clazz instanceof IntegerProperty ? "Integer" : (clazz instanceof EnumProperty ? "Enum" : (clazz instanceof DirectionProperty ? "Direction" : clazz.getClass().getSimpleName())));
    }
}

